### What is HMAC?

- **HMAC** is a type of cryptographic algorithm used to verify both the **integrity** and **authenticity** of a message.
- It combines a cryptographic **hash function** (such as SHA-256 or MD5) with a **secret key**.
- The sender and receiver must both know the secret key.

### How does HMAC work?

1. The sender combines the message with a secret key and runs it through a hash function, creating a unique code (the HMAC).
2. The sender sends both the message and the HMAC to the receiver.
3. The receiver uses the same key and hash function to generate an HMAC from the received message.
4. If the HMACs match, it confirms the message hasn’t been changed and comes from a trusted source.

### Why is HMAC important?

- **Integrity:** Ensures the data has not been altered in transit.
- **Authenticity:** Verifies the message is from someone who knows the shared secret key.

### Where is HMAC used?

- Commonly used in SSL/TLS protocols, VPNs, and other secure communications to protect data from tampering.